#!/bin/sh

attempts=5
while [ $attempts -gt 0 ]; do
        attempts=$((attempts-1))
        [ -e /sys/class/net/eth1 ] && break
        sleep 2
done

[ ! -e /sys/class/net/eth1 ] && exit 0

static=1
grep -v "^#" /etc/network/interfaces | grep eth1 | grep static
if [ $? -eq 0 ]; then
        static=1
else
        static=0
fi

if [ $static -ne 0 ]; then
        ifconfig eth1 192.168.13.1 up
        exit 0
fi

pid=$(ps -ef | grep dhclient | grep eth1 | awk '{print $2}')

if [ "$pid" != "" ]; then
        kill $pid
fi

ifconfig eth1 0.0.0.0 up
attempts=5
while [ $attempts -gt 0 ]; do
        attempts=$((attempts-1))
        dhclient eth1 && break
done
