#!/bin/bash

set -e

targetVersion=$1

if [ -z "$targetVersion" ]; then
	echo "You need to provide version number as a parameter. Example usage: '"${BASH_SOURCE[0]}" 1.0.4'"
	exit 1
fi

apt-get update -o Dir::Etc::sourcelist=/etc/apt/sources.list.d/signaltek-online.list -o Dir::Etc::sourceparts='-' -o APT::Get::List-Cleanup='0'

apt-cache policy -o Dir::Etc::sourcelist=/etc/apt/sources.list.d/signaltek-online.list -o Dir::Etc::sourceparts='-' -o APT::Get::List-Cleanup='0' signaltek10g


apt-get install -o Dir::Etc::sourcelist=/etc/apt/sources.list.d/signaltek-online.list -o Dir::Etc::sourceparts='-' -o APT::Get::List-Cleanup='0' signaltek10g=$targetVersion
