
# LimeReport

SignalTEK 10G uses LimeReport for PDF generating. 

Original source code: https://github.com/fralx/LimeReport

Website: https://limereport.ru/en/index.php

License: LGPL

## Getting Code

LimeReport code for S10G can be cloned with `git@gitlab.com:ideal_networks_signaltek/LimeReport.git`

## Documentation

Documentation can be found in sources: `LimeReport/docs/UserManualEn.pdf`

## LimeReport IDE

Build LimeReport code by loading its project using QtCreator and run 'designer' to show IDE.

## LimeReport Console

To generate PDF, S10G uses modified console app from LimeReport project. It's migrating databases, parsing .ini file to LimeReport parameters and more. Please check out main.cpp for full picture.

## Maintaining LimeReport

To update LimeReport template, please open `SignalTEK/reports/lime_report.lrxml` in LimeReport IDE. To make lime_report template work properly, make sure you have /opt/SignalTEK/reports/pdf_report.db file with DB prepared by S10G app by 'Generate PDF' feature.

### Summary Page

Summary page of the report

### Report Page

This tab contains subtest segments which will be divided to several A4 pages.

### Additional Translations

TextFields created to 'cheat' LimeReport with handling Database translations. Put in there translations for dynamic data obtained from Database or parameters.ini and handle it inside Script tab.

### Script

Advanced scripting of the fields. Please follow usage of particular function in fields or open lime_report.lrxml with text editor and search for it.

### Translations

Maintain translations in this tab. You can 'Export TS', update translation inside QtLinguist and then 'Import TS'. Please be aware that when importing from TS, 'Checked' flag can be unchecked automatically and you have to verify all languages and all strings to make sure everything is translated and has 'Checked' flag set to true.

## Docker image for Cloud

Cloud Portal uses LimeReport to generate PDF as well. LimeReport is stored inside Docker container for our convenience.

### Docker image deployment/update

Whenever you update Docker image with new features/fixes, you have to remember about updating verion number inside `SignalTEK/scripts/reports/create_docker_image.sh`.

### Docker image creation

To deploy docker image files use `SignalTEK/scripts/reports/deploy_docker_image.sh`. It will create `signaltek_report_docker.tgz` inside `SignalTEK/docker/reports`.

### Docker image deployment

Make sure you have an access to the target server (e.g. id-azwe-st3srv001 SNT: 52.174.56.137). Remember that you need your personal user account.

1. Upload `signaltek_report_docker.tgz` to target server into `/home/cloudthing/` 

2. Please remember about moving/copying previous signaltek_report_docker to e.g. `/home/cloudthing/signaltek_report_docker_1.9`

3. Extract `signaltek_report_docker.tgz` with `tar -xf signaltek_report_docker.tgz`

4. Change owner for dir `chown -R cloudthing.users signaltek_report_docker`

5. Update Docker image with 'cd /home/cloudthing/signaltek_report_docker && ./create_docker_image.sh'

### Capture report data

1. SSH into docker server

2. Uncomment `sleep 30` line in `/home/cloudthing/signaltek_report_docker/run_docker.sh`

3. Capture `cp -r /home/cloudthing/signaltek_report_docker/tmp/SOME_REPORT_ID /tmp/report_data` (replace SOME_REPORT_ID with report id - use `watch -n1 ls -l` on a tmp dir)

4. Comment out `sleep 30` line again
